package w83b.w83bManager;


import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import w83b.w83bBeans.W83bCitacionBean;
import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bImpugnacionBean;
import w83b.w83bBeans.W83bSindicatosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bDAO.W83bFactoriaDAO;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesLibroRegistro.W83bLibroRegistro;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;


// TODO: Auto-generated Javadoc
/**
 * The Class W83bCitaciones.
 */
public class W83bCitaciones implements W83bICitaciones {
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bICitaciones#buscarCitaciones(w83b.w83bBeans.W83bCitacionBean)
	 */
	public java.util.List buscarCitaciones(w83b.w83bBeans.W83bCitacionBean param) throws Exception{
		List listaActas = W83bFactoriaDAO.getCitacionesDAO().buscarCitaciones(param);
		
		return listaActas;	
	}
	
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bICitaciones#contarCitaciones(w83b.w83bBeans.W83bCitacionBean)
	 */
	public java.lang.Integer contarCitaciones(w83b.w83bBeans.W83bCitacionBean param) throws Exception{
		
		return new Integer(W83bFactoriaDAO.getCitacionesDAO().contarCitaciones(param));	
	}


	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bICitaciones#anyadirCitaciones(w83b.w83bBeans.W83bCitacionBean)
	 */
	public W83bCitacionBean anyadirCitaciones(W83bCitacionBean param) throws Exception {//NOPMD
		param=W83bFactoriaDAO.getCitacionesDAO().anyadirCitaciones(param);
		W83bFactoriaDAO.getCitacionesDAO().anyadirSindicatos(param);
		W83bFactoriaDAO.getCitacionesDAO().anyadirInteresados(param);
		return param;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bICitaciones#cargarDatosImpugnacion(java.util.HashMap)
	 */
	public W83bImpugnacionBean cargarDatosImpugnacion(HashMap mapaResultado) throws Exception{
		W83bImpugnacionBean bean=new W83bImpugnacionBean();
		boolean existeCitacion=W83bFactoriaDAO.getCitacionesDAO().existeCitacion(mapaResultado);
		
		if(!existeCitacion)
		{
			bean= W83bFactoriaDAO.getCitacionesDAO().obtenerDatosBasicosImpugnacion(mapaResultado);
			
		}
		bean.setExisteCitacion(existeCitacion);
		return bean;
	}
	
	public W83bSindicatosBean cargarDatosSindicatos(String codigo) throws Exception{
		return W83bFactoriaDAO.getCitacionesDAO().cargarDatosSindicatos(codigo);
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bICitaciones#cargarDatosImpugnacionEdicion(java.util.HashMap)
	 */
	public W83bImpugnacionBean cargarDatosImpugnacionEdicion(HashMap mapaResultado) throws Exception{
		W83bImpugnacionBean bean= W83bFactoriaDAO.getCitacionesDAO().obtenerDatosBasicosImpugnacion(mapaResultado);
		
		return bean;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bICitaciones#obtenerCitas(java.util.HashMap)
	 */
	public List obtenerCitas(HashMap param) throws Exception{
		return W83bFactoriaDAO.getCitacionesDAO().obtenerCitas(param);
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bICitaciones#obtenerDetallesImpugnacion(java.util.HashMap)
	 */
	public W83bCitacionBean obtenerDetallesImpugnacion(HashMap param)
			throws Exception {
		
		return W83bFactoriaDAO.getCitacionesDAO().obtenerDatosBasicosCitacion(param,(W83bUsuarioXLNetsBean)param.get("Usuario"));
	}

	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bICitaciones#existeImpugnacion(w83b.w83bBeans.W83bCitacionBean)
	 */
	public boolean existeImpugnacion(W83bCitacionBean param)
			throws Exception {
		return W83bFactoriaDAO.getCitacionesDAO().existeCitacion(param);
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bICitaciones#edicionCitaciones(w83b.w83bBeans.W83bCitacionBean)
	 */
	public String edicionCitaciones(W83bCitacionBean param) throws Exception {
		
		W83bFactoriaDAO.getCitacionesDAO().editarCitaciones(param);
		W83bFactoriaDAO.getCitacionesDAO().borrarSindicatosCitaciones(param);
		W83bFactoriaDAO.getCitacionesDAO().editarSindicatos(param);
		W83bFactoriaDAO.getCitacionesDAO().borrarInteresadosCitaciones(param);
		W83bFactoriaDAO.getCitacionesDAO().editarInteresados(param);
		
		return param.getCodSelec();
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bICitaciones#borrarCitaciones(java.util.List)
	 */
	public String borrarCitaciones(List param) throws Exception {
		boolean borrado = true;
		
		W83bUsuarioXLNetsBean userBean = (W83bUsuarioXLNetsBean)param.get(param.size()-1);
		param.remove(param.size()-1);
		
		for(int i=0;i<param.size();i++){
			
			borrado =  W83bFactoriaDAO.getCitacionesDAO().borrarSindicatos((String)param.get(i),userBean);
			borrado =  W83bFactoriaDAO.getCitacionesDAO().borrarInteresados((String)param.get(i),userBean);
			borrado = W83bFactoriaDAO.getCitacionesDAO().borrarTramite((String)param.get(i),userBean);
			borrado =  W83bFactoriaDAO.getCitacionesDAO().borrarCitacion((String)param.get(i),userBean);
			
			if(!borrado){
				break;
			}
		}
		
		if (borrado)
				return "success";
			else 
				throw new Exception();//NOPMD;
		
	}

	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bICitaciones#existeCitacion(w83b.w83bBeans.W83bCitacionBean)
	 */
	public boolean existeCitacion(W83bCitacionBean param) throws Exception {
		return W83bFactoriaDAO.getCitacionesDAO().existeCitacion(param);
	}

	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bICitaciones#obtenerDetallesCitacion(java.util.HashMap)
	 */
	public W83bCitacionBean obtenerDetallesCitacion(HashMap param)throws Exception {
		
		
		W83bCitacionBean bean=  W83bFactoriaDAO.getCitacionesDAO().obtenerDatosBasicosCitacion(param,(W83bUsuarioXLNetsBean)param.get("Usuario"));
		List plantillas=new ArrayList();
		plantillas.add(W83bClsConstantes.ETIQUETAS);
		plantillas.add(W83bClsConstantes.CARTAS);
		plantillas.add(W83bClsConstantes.ACUSES);
		plantillas.add(W83bClsConstantes.RELACUSES);
		plantillas.add(W83bClsConstantes.NOTIFICACION_CITACION);
		bean.setPlantillasRTF(W83bFactoriaDAO.getMantenimientosDAO().buscarPlantillas(plantillas));
		return bean;
		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bICitaciones#obtenerDetallesComunicacionCitacion(java.util.HashMap)
	 */
	public HashMap obtenerDetallesComunicacionCitacion(HashMap param)
	throws Exception {
		W83bUsuarioXLNetsBean usuarioLimitado = ((W83bIComunes)(W83bComunes.class.newInstance())).refrescarUsuarioDelegacion((W83bUsuarioXLNetsBean)param.get("Usuario"));
		
		((W83bUsuarioXLNetsBean)param.get("Usuario")).setModelo(usuarioLimitado.getModelo());
		((W83bUsuarioXLNetsBean)param.get("Usuario")).setModeloSal(usuarioLimitado.getModeloSal());
		String observaciones="Citacion de la impuganacion n: "+(String)param.get("territorio")+"/"+(String)param.get("anyo")+"/"+(String)param.get("numImpugnacion");//NOPMD
		String [] resul=W83bLibroRegistro.getAltaRegistro(true, 
				((W83bUsuarioXLNetsBean)param.get("Usuario")).getModeloSal(), "S", "E", 
				Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",(String)param.get("idioma"),null)
				, (String)param.get("territorio"), "" ,observaciones, (W83bUsuarioXLNetsBean)param.get("Usuario")
		);
		HashMap mapa = W83bFactoriaDAO.getCitacionesDAO().obtenerDatosComunicacionCitacion(param,(W83bUsuarioXLNetsBean)param.get("Usuario"));
		
		mapa.put("numRegistro", resul);
		
		return mapa;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bICitaciones#obtenerDetallesComunicacionCitacion(java.util.HashMap)
	 */
	public String guardarComunicacionCitacion(HashMap param)
	throws Exception {
//		W83bUsuarioXLNetsBean usuarioLimitado = ((W83bIComunes)(W83bComunes.class.newInstance())).refrescarUsuarioDelegacion((W83bUsuarioXLNetsBean)param.get("Usuario"));
//		 
//		((W83bUsuarioXLNetsBean)param.get("Usuario")).setModelo(usuarioLimitado.getModelo());
//		 ((W83bUsuarioXLNetsBean)param.get("Usuario")).setModeloSal(usuarioLimitado.getModeloSal());
//		String [] resul=W83bLibroRegistro.getAltaRegistro(true, 
//				((W83bUsuarioXLNetsBean)param.get("Usuario")).getModeloSal(), "S", "E", 
//				Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",(String)param.get("idioma"),null)
//				, (String)param.get("territorio"), "" ,"", (W83bUsuarioXLNetsBean)param.get("Usuario")
//		);
		
		String[] resul = (String[])param.get("numRegistro");
		
		W83bDocBean docBean=new W83bDocBean();//NOPMD
		docBean.setNumActaTerritorio((String)param.get("territorio"));
		docBean.setNumActaAno((String)param.get("anyo"));
		docBean.setNumActa((String)param.get("numImpugnacion"));
		docBean.setCodTramite(String.valueOf(W83bClsConstantes.TRAMITE_CITACION_ARBITRAL));
		docBean.setCodFase(String.valueOf(W83bClsConstantes.FASE_IMPUGNACION));
		docBean.setFechaRegistro(resul[1]);
		docBean.setUsuario(((W83bUsuarioXLNetsBean)param.get("Usuario")).getIdUsuario());
		docBean.setNumeroRegistro(resul[0]);
		docBean.setEscomunicacion("impug");
		byte[] bytes = ((StringBuffer)param.get("bufferComunicacion")).toString().getBytes();
		InputStream input=new ByteArrayInputStream(bytes);//NOPMD
		docBean.setFileData(input);
		docBean.setNombre("ComunicacionImpugnacion"
				+(String)param.get("territorio")+"/"+
				(String)param.get("anyo")+"/"+
				(String)param.get("numImpugnacion")+".rtf");
		docBean.setTamanyo(((StringBuffer)param.get("bufferComunicacion")).toString().getBytes().length);
		
		List listaEntrada = new ArrayList();
		listaEntrada.add(docBean);
		
		HashMap entrada = new HashMap();
		entrada.put("comunicind",listaEntrada);
		
		
		((W83bIComunicaciones)(W83bComunicaciones.class.newInstance())).insertarComunicInd(entrada);
		
		return "";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bICitaciones#obtenerDetallesAcuseCitacion(java.util.HashMap)
	 */
	public HashMap obtenerDetallesAcuseCitacion(HashMap param)throws Exception {

		return W83bFactoriaDAO.getCitacionesDAO().obtenerDatosAcuseCitacion(param,(W83bUsuarioXLNetsBean)param.get("Usuario"));
	}

}